<?php
require '../../data.php';

$kodekeluhan = htmlspecialchars($_POST['tampilkode']);

// Prepare and execute the select query for `keluhan_member`
$skeluhan = "SELECT * FROM keluhan_member WHERE kode_keluhan = ?";
$stmt1 = mysqli_prepare($data, $skeluhan);
mysqli_stmt_bind_param($stmt1, "s", $kodekeluhan);
mysqli_stmt_execute($stmt1);
$qkeluhan = mysqli_stmt_get_result($stmt1);

if (mysqli_num_rows($qkeluhan) > 0) {
    // Prepare and execute the select query for `kasus_keluhan`
    $skas = "SELECT user_keluhan FROM kasus_keluhan WHERE kode_kasus = ?";
    $stmt2 = mysqli_prepare($data, $skas);
    mysqli_stmt_bind_param($stmt2, "s", $kodekeluhan);
    mysqli_stmt_execute($stmt2);
    $qkas = mysqli_stmt_get_result($stmt2);
    $fkas = mysqli_fetch_assoc($qkas);

    echo '<input type="hidden" name="kodehid" value="' . htmlspecialchars($kodekeluhan) . '" />
          <input type="hidden" name="userhid" value="' . htmlspecialchars($fkas['user_keluhan']) . '" />';

    while ($fkeluhan = mysqli_fetch_assoc($qkeluhan)) {
        $sender = htmlspecialchars($fkeluhan['sender_keluhan']);
        $receiver = htmlspecialchars($fkeluhan['receiver_keluhan']);
        $message = htmlspecialchars($fkeluhan['msg_keluhan']);
        $tglkelu = htmlspecialchars($fkeluhan['tgl_keluhan']);
        $baca = htmlspecialchars($fkeluhan['baca_keluhan']);

        if ($sender) {
            echo '<div class="d-flex justify-content-end">
                    <div class="sender">
                        <h2 class="m-0 text-capitalize p-0">' . $sender . ' ' . $kodekeluhan . '</h2>
                        <p style="font-size: 0.6rem; color : #715600;" class="m-0 mb-1 p-0"><i class="fas fa-clock"></i> ' . date("d M Y H:i:s", strtotime($tglkelu)) . '</p>
                        <p>' . $message . '</p>
                    </div>
                </div>';
        } else {
            echo '<div class="d-flex justify-content-start">
                    <div class="receiver">
                        <h2 class="m-0 text-capitalize p-0">' . $receiver . '</h2>';
            if ($baca == '0') {
                echo '<span class="badge bg-danger blinks">BARU</span>';
            }
            echo '<p style="font-size: 0.6rem;" class="text-secondary m-0 mb-1 p-0"><i class="fas fa-clock"></i> ' . date("d M Y H:i:s", strtotime($tglkelu)) . '</p>
                        <p>' . $message . '</p>
                    </div>
                </div>';
        }
    }

    mysqli_stmt_close($stmt2);
} else {
    echo '<p class="text-danger fw-bold">Kode Keluhan tidak ditemukan!!. Mohon diperiksa kembali kode yang dimasukkan.</p>
          <p class="text-danger">Pastikan ada tanda <strong>#</strong> diawal kode misal: #123456</p>';
}

mysqli_stmt_close($stmt1);
mysqli_close($data);
